/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.WebSession;
import itx.erp.base.service.WebSessionService;
import itx.erp.helper.ErpConfig;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.db.common.QueryResult;

public class WebSessionsController
extends BaseController {
    protected ErpConfig appConfig;
    protected WebSessionService webSessionService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public WebSessionService getWebSessionService() {
        return this.webSessionService;
    }

    public void setWebSessionService(WebSessionService webSessionService) {
        this.webSessionService = webSessionService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void searchAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        this.getWebSessionService().cleanupSessions();
        Integer pageNo = req.getParamInt("pageNo", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.appConfig.getLimit());
        opts.put("pageSize", this.appConfig.getLimit());
        opts.put("q", req.getParameter("q"));
        QueryResult<WebSession> qrs = this.getWebSessionService().searchSession(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("websessions", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        if (req.getWebSession() != null) {
            result.put("currentWebSessionId", req.getWebSession().getWebSessionId());
        }
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        Integer sessionId = req.getParamInt("webSessionId");
        this.getWebSessionService().destroySession(sessionId);
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }
}

